/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.DetailsFrameBean;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.config.NetworkInterfaceConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPAddressBean
extends PanelBean
implements SettingsConstants,
SettingsErrorIds {
    private String m_sMacAddr;
    private String m_sMediaSpeed;
    private ValueDescriptor[] m_cdMediaSpeed;
    private String m_sIPAddr;
    private String m_sMask;
    private String[] m_sDHCPClientSelection;
    private NetworkInterfaceInformation _netif;
    private NetworkSettingsConfig netSetConfig;
    private NetworkInterfaceConfig[] netIfConfigArray;
    private NetworkInterfaceConfig netIfConfig;
    private Integer _netifIndex;
    private String macaddrText;
    private String ifName;
    private String platform;
    private boolean m_PartComm;
    private boolean configured = false;
    private static final String TRACE_MASKT = "XSETIPBT";
    private static final String TRACE_MASKF = "XSETIPBF";
    private static final String TRACE_MASKD = "XSETIPBD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "IPAddressBean");

    public NetworkInterfaceInformation get_netif() {
        return this._netif;
    }

    public void set_netif(NetworkInterfaceInformation ifs) {
        Trace.trace(TRACE_MASKT, "   <> IPAddressBean.set_netif()");
        this._netif = ifs;
    }

    public Integer get_netifIndex() {
        return this._netifIndex;
    }

    public NetworkSettingsConfig getNetSetConfig() {
        return this.netSetConfig;
    }

    public NetworkInterfaceConfig getNetIfConfig() {
        return this.netIfConfig;
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public void setConfigured(boolean b) {
        Trace.trace(TRACE_MASKT, "   <> IPAddressBean.setConfigured(): [" + b + "]");
        this.configured = b;
    }

    public String getMacAddr() {
        return this.m_sMacAddr;
    }

    public void setMacAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "   IPAddressBean.setMacAddr: [" + s + "]");
        this.m_sMacAddr = s;
    }

    public String getMediaSpeed() {
        return this.m_sMediaSpeed;
    }

    public void setMediaSpeed(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "   IPAddressBean.setMediaSpeed: [" + s + "]");
        this.m_sMediaSpeed = s;
    }

    public ValueDescriptor[] getMediaSpeedList() {
        Trace.trace(TRACE_MASKT, "   <> IPAddressBean.getMediaSpeedList");
        return this.m_cdMediaSpeed;
    }

    public String[] getDHCPClientSelection() {
        return this.m_sDHCPClientSelection;
    }

    public void setDHCPClientSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.setDHCPClientSelection: " + selected[0]);
        if (selected[0].length() < 14) {
            System.out.println("What's going on here? IGNORE this bad call!!!");
        } else {
            this.m_sDHCPClientSelection = selected;
            if (selected.length > 0 && this.getMountPrefix() != null) {
                if (selected[0].endsWith("MANUALBUTTON")) {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", true);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", true);
                } else {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "ipAddressField", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "maskField", false);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.setDHCPClientSelection: " + selected[0]);
    }

    public boolean isPartitionCommunication() {
        return this.m_PartComm;
    }

    public void setPartitionCommunication(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.setPartitionCommunication: " + b);
        this.m_PartComm = b;
    }

    public String getIPAddr() {
        return this.m_sIPAddr;
    }

    public void setIPAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "   IPAddressBean.setIPAddr: [" + s + "]");
        if (this.ifName.equals("eth0") && s.equals("0.0.0.0")) {
            Trace.trace(TRACE_MASKT, "   Illegal address for eth0 - make it localhost instead");
            s = "127.0.0.1";
        }
        this.m_sIPAddr = s;
    }

    public String getMask() {
        return this.m_sMask;
    }

    public void setMask(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "   IPAddressBean.setMask: [" + s + "]");
        this.m_sMask = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.prepare()");
        if (this._netif.isDhcpClient()) {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "DHCPBUTTON"});
        } else {
            this.setDHCPClientSelection(new String[]{this.getMountPrefix() + "MANUALBUTTON"});
        }
        Trace.trace(TRACE_MASKT, "   isDhcpClient() = " + this._netif.isDhcpClient());
        try {
            this.userTaskManager.setShown(this.getMountPrefix() + "DHCPSERVERINFOBOX", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "PublicPrivateGroup", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "PartitionComm", false);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "These don't exist (ie on SE) ignore any errors");
        }
        if (this.netIfConfig != null) {
            Trace.trace(TRACE_MASKT, "   Setup initial values according to config file");
            int addrType = this.netIfConfig.getAddressType();
            Trace.trace(TRACE_MASKT, "   -> AddressType = [" + addrType + "]");
            switch (addrType) {
                case 0: {
                    String[] fixedAddr = new String[]{this.getMountPrefix() + "MANUALBUTTON"};
                    this.setDHCPClientSelection(fixedAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DHCPBUTTON", false);
                    break;
                }
                case 1: {
                    String[] dhcpClntAddr = new String[]{this.getMountPrefix() + "DHCPBUTTON"};
                    this.setDHCPClientSelection(dhcpClntAddr);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "MANUALBUTTON", false);
                    break;
                }
                default: {
                    Trace.trace(TRACE_MASKT, "   CustomerChoice: Use previous static/dhcpC setting: dhcpC = " + this._netif.isDhcpClient());
                }
            }
            Trace.trace(TRACE_MASKT, "   <- AddressType = [" + addrType + "]");
            this.configured = true;
        } else {
            Trace.trace(TRACE_MASKT, "   This lan not found in config file, or we're running RedHat");
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.prepare()");
    }

    public void panelAction(TaskActionEvent event) {
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKF, "-> IPAddressBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("ipaddresspanel");
        if (command.endsWith("detailsOkButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IPAddressBean) ");
            Trace.trace(TRACE_MASKF, "getDHCPClientSelection[0] = " + this.getDHCPClientSelection()[0]);
            Trace.trace(TRACE_MASKF, "getMountPrefix = " + this.getMountPrefix());
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            Trace.trace(TRACE_MASKF, " Data Read: getDHCPClientSelection() = " + this.getDHCPClientSelection()[0]);
            Trace.trace(TRACE_MASKF, " Data Read: getIPAddr() = " + this.getIPAddr());
            Trace.trace(TRACE_MASKF, " Data Read: getMask() = " + this.getMask());
            Trace.trace(TRACE_MASKF, " Data Read: getMacAddr() = " + this.getMacAddr());
            Trace.trace(TRACE_MASKF, " Data Read: configured = " + this.configured);
            this._netif.setMediaSpeed(this.getMediaSpeed());
            this._netif.setConfigured(this.configured);
            try {
                this._netif.setIpAddress(InetAddress.getByName(this.getIPAddr()));
                this._netif.setNetworkMask(InetAddress.getByName(this.getMask()));
                Trace.trace(TRACE_MASKF, "\n getMask() = " + this.getMask());
                Trace.trace(TRACE_MASKF, "_netif.getNetMask() = " + this._netif.getNetMask() + "\n");
            }
            catch (UnknownHostException exc) {
                Trace.trace(TRACE_MASKF, "ILLEGAL DATA ENTERED!   UnknownHostException!!  ");
                HException hexc = new HException(exc);
                new FrameworkLog(_logInfo, 2395, hexc).log();
            }
            String dhcpState = this.getDHCPClientSelection()[0];
            dhcpState = dhcpState.substring(dhcpState.lastIndexOf(".") + 1);
            if (dhcpState.startsWith("DHCP")) {
                this._netif.setDhcpClient(true);
            } else {
                this._netif.setDhcpClient(false);
            }
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getIpAddress(): " + this._netif.getIpAddr());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getNetworkMask(): " + this._netif.getNetMask());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getAdapterType(): " + this._netif.getAdapterType());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.getMacAddress(): " + this._netif.getMacAddress());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isDhcpClient(): " + this._netif.isDhcpClient());
            Trace.trace(TRACE_MASKF, "New netif data:  netif.isConfigured(): " + this._netif.isConfigured());
            request.setData("panel", "ipaddresspanel");
            request.setData("dataupdates", this._netif);
            request.setData("data", this._netifIndex);
            this.postTaskletRequest(request);
        } else if (command.endsWith("detailsCancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (IPAddressBean) ");
            UserTaskManager utm = (UserTaskManager)event.getSource();
            this.storeMyElements();
            boolean dhcpClientFlag = false;
            String dhcpClientState = this.getDHCPClientSelection()[0];
            dhcpClientState = dhcpClientState.substring(dhcpClientState.lastIndexOf(".") + 1);
            if (dhcpClientState.startsWith("DHCP")) {
                dhcpClientFlag = true;
            }
            if (this._netif.isDhcpClient() != dhcpClientFlag || !this._netif.getIpAddr().equals(this.m_sIPAddr) || !this._netif.getNetMask().equals(this.m_sMask)) {
                ((DetailsFrameBean)parent).setDataChanged();
                Trace.trace(TRACE_MASKT, "   IPAddressBean believes data has changed");
            }
        }
        Trace.trace(TRACE_MASKF, "<- IPAddressBean.parentalAction()");
    }

    public void storeMyElements() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.storeMyElements()");
        this.userTaskManager.storeElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.storeElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.storeElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.storeElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.storeElement(this.getMountPrefix() + "AddressRange");
        Trace.trace(TRACE_MASKT, "   m_sIPAddr " + this.m_sIPAddr);
        Trace.trace(TRACE_MASKT, "   m_sMask " + this.m_sMask);
        Trace.trace(TRACE_MASKT, "   m_sMacAddr " + this.m_sMacAddr);
        Trace.trace(TRACE_MASKT, "   m_sMediaSpeed " + this.m_sMediaSpeed);
        Trace.trace(TRACE_MASKT, "   m_sDHCPClientSelection " + this.m_sDHCPClientSelection[0]);
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.storeMyElements()");
    }

    public void refreshMyElements() {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.refreshMyElements()");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "ipAddressField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "maskField");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "macAddr");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "MediaSpeed");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "DHCPClient");
        this.userTaskManager.refreshElement(this.getMountPrefix() + "AddressRange");
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.refreshMyElements()");
    }

    public void setNetworkInterface(NetworkInterfaceInformation netif, Integer netifIndex, NetworkSettingsConfig networkSettingsConfig) {
        Trace.trace(TRACE_MASKT, "-> IPAddressBean.setNetworkInterface()");
        this.ifName = netif.getIfname();
        this.setIPAddr(netif.getIpAddr().trim());
        this.setMask(netif.getNetMask().trim());
        String macaddress = netif.getMacAddress();
        int length = macaddress.length();
        this.macaddrText = "";
        for (int i = 0; i < length && i < 24; i += 2) {
            this.macaddrText = this.macaddrText + macaddress.substring(i, i + 2);
            if (i >= length - 2) continue;
            this.macaddrText = this.macaddrText + ":";
        }
        Trace.trace(TRACE_MASKT, "  macaddrText = " + this.macaddrText);
        this.setMacAddr(this.macaddrText + " " + netif.getIfname());
        this.configured = netif.isConfigured();
        this.m_sMediaSpeed = netif.getMediaSpeed();
        Trace.trace(TRACE_MASKT, "   m_sIPAddr " + this.m_sIPAddr);
        Trace.trace(TRACE_MASKT, "   m_sMask " + this.m_sMask);
        Trace.trace(TRACE_MASKT, "   m_sMacAddr " + this.m_sMacAddr);
        Trace.trace(TRACE_MASKT, "   Configured =" + this.configured);
        Trace.trace(TRACE_MASKT, "   m_sMediaSpeed " + this.m_sMediaSpeed);
        this._netif = netif;
        this._netifIndex = netifIndex;
        this.netSetConfig = networkSettingsConfig;
        if (this.netSetConfig != null) {
            this.netIfConfigArray = networkSettingsConfig.getNetworkInterfacesArray();
            boolean netIntConfFound = false;
            for (int i = 0; i < this.netIfConfigArray.length && !netIntConfFound; ++i) {
                Trace.trace(TRACE_MASKF, "interfaceID = " + this.netIfConfigArray[i].getInterfaceID());
                if (!this.ifName.equals(this.netIfConfigArray[i].getInterfaceID())) continue;
                this.netIfConfig = this.netIfConfigArray[i];
                netIntConfFound = true;
                Trace.trace(TRACE_MASKF, this.ifName + " is adapter number " + i + " in the config file");
            }
            if (!netIntConfFound) {
                Trace.trace(TRACE_MASKF, this.ifName + " is not found in the config file");
            }
        }
        Trace.trace(TRACE_MASKT, "<- IPAddressBean.setNetworkInterface()");
    }
}

